# -*- coding: utf-8 -*-
"""Régression linéaire et constante de Planck

**Exemple de régression linéaire : effet photoélectrique**

Données :
"""

import numpy as np
import matplotlib.pyplot as plt
from random import *

# Fréquences en Hz

frequences = np.array([11.825,10.111,8.210,7.4129,6.8838])*1e14
u_frequences = np.array([2.3,1.7,1.1,0.91,0.79])*1e12

# Ec en J

Ec = np.array([2.40,1.69,0.91,0.57,0.35])*1.6e-19
u_Ec = 0.05*1.6e-19

"""Régression linéaire"""

# Calcul de la valeur centrale de la mesure par régression linéaire

h,ordonnee = np.polyfit(frequences,Ec,1)

"""Simulation Monte-Carlo pour estimer l'incertitude-type"""

# Nombre de simulations pour estimer l'incertitude-type

N = 1000

# Initialisation des listes
liste_h,liste_ordonnee = [], []


for i in range(0,N):
    l = len(frequences) 
    my = Ec + u_Ec*np.sqrt(3)*np.random.uniform(-1,1,l) 
    mx = frequences + u_frequences*np.sqrt(3)*np.random.uniform(-1,1,l)

    p=np.polyfit(mx,my,1)
    liste_h.append(p[0])
    liste_ordonnee.append(p[1])


u_h = np.std(liste_h,ddof=1)
u_ordonnee = np.std(liste_ordonnee,ddof=1)

"""Tracé de la régression"""

xfit=np.linspace(min(frequences),max(frequences),2)

plt.plot(xfit, ordonnee + h*xfit, 'r', label='Régression linéaire')
plt.errorbar(frequences,Ec,xerr=u_frequences ,yerr=u_Ec,fmt='b+',zorder=2,label='Mesures')
plt.title("Tracé de l'évolution de l'énergie des électrons en fonction de la fréquence")
plt.xlabel("Fréquence en Hz")
plt.ylabel("Énergie cinétique en J")
plt.legend()
plt.show()

"""Affichage du résultat"""

print("Constante de Planck = {:.2e} +/- {:.2e} J.s".format(h,u_h))

nu_s = -ordonnee / h
u_nu_s = nu_s * np.sqrt((u_ordonnee/ordonnee)**2 + (u_h/h)**2 )

print("Fréquence de seuil = {:.2e} +/- {:.2e} Hz".format(nu_s,u_nu_s))
